/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.ClientTextComponentUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.ChangeChapterGroupScreen;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.net.MoveChapterGroupMessage;
import dev.ftb.mods.ftbquests.net.MoveChapterMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.Nullable;

public class ChapterPanel
extends Panel {
    public static boolean pinned = false;
    public static final Icon ARROW_COLLAPSED = Icon.getIcon((String)"ftbquests:textures/gui/arrow_collapsed.png");
    public static final Icon ARROW_EXPANDED = Icon.getIcon((String)"ftbquests:textures/gui/arrow_expanded.png");
    public final QuestScreen questScreen;
    public boolean expanded = pinned;

    public ChapterPanel(Panel panel) {
        super(panel);
        this.questScreen = (QuestScreen)panel.getGui();
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.questScreen.viewQuestPanel.quest != null) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void addWidgets() {
        this.add((Widget)new ModpackButton(this, this.questScreen.file));
        boolean canEdit = this.questScreen.file.canEdit();
        for (Chapter chapter : this.questScreen.file.defaultChapterGroup.getVisibleChapters(this.questScreen.file.self)) {
            this.add((Widget)new ChapterButton(this, chapter));
        }
        if (canEdit) {
            // empty if block
        }
        for (ChapterGroup group : this.questScreen.file.chapterGroups) {
            if (group.isDefaultGroup()) continue;
            ChapterGroupButton b = new ChapterGroupButton(this, group);
            if (canEdit || !b.visibleChapters.isEmpty()) {
                this.add((Widget)b);
                if (!group.guiCollapsed) {
                    for (Chapter chapter : b.visibleChapters) {
                        this.add((Widget)new ChapterButton(this, chapter));
                    }
                }
            }
            if (!canEdit) continue;
        }
    }

    public void alignWidgets() {
        int wd = 100;
        for (Widget w : this.widgets) {
            wd = Math.min(Math.max(wd, ((ListButton)w).getActualWidth(this.questScreen)), 800);
        }
        this.setPosAndSize((this.expanded || pinned) && !this.questScreen.isViewingQuest() ? 0 : -wd, 0, wd, this.questScreen.height);
        for (Widget w : this.widgets) {
            w.setWidth(wd);
        }
        this.align(WidgetLayout.VERTICAL);
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        super.updateMouseOver(mouseX, mouseY);
        if (this.expanded && !pinned && !this.isMouseOver()) {
            this.setExpanded(false);
        }
    }

    public int getX() {
        return (this.expanded || pinned) && !this.questScreen.isViewingQuest() ? 0 : -this.width;
    }

    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        theme.drawContextMenuBackground(matrixStack, x, y, w, h);
    }

    public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 600.0);
        RenderSystem.m_69482_();
        super.draw(matrixStack, theme, x, y, w, h);
        matrixStack.m_85849_();
    }

    public void setExpanded(boolean b) {
        this.expanded = b;
    }

    public static class ModpackButton
    extends ListButton {
        public ModpackButton(ChapterPanel panel, ClientQuestFile f) {
            super(panel, f.getTitle(), f.getIcon());
            this.setSize(100, 18);
        }

        public void onClicked(MouseButton button) {
            if (this.getMouseX() > this.getX() + this.width - 18) {
                this.playClickSound();
                pinned = !pinned;
            } else if (this.chapterPanel.questScreen.file.canEdit() && this.getMouseX() > this.getX() + this.width - 34) {
                this.playClickSound();
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.chapter"), (Icon)ThemeProperties.ADD_ICON.get(), () -> {
                    StringConfig c = new StringConfig(Pattern.compile("^.+$"));
                    EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                        this.chapterPanel.questScreen.openGui();
                        if (accepted && !((String)c.value).isEmpty()) {
                            Chapter chapter = new Chapter(this.chapterPanel.questScreen.file, this.chapterPanel.questScreen.file.defaultChapterGroup);
                            chapter.title = (String)c.value;
                            CompoundTag extra = new CompoundTag();
                            extra.m_128356_("group", 0L);
                            new CreateObjectMessage(chapter, extra).sendToServer();
                        }
                        this.run();
                    });
                }));
                contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.chapter_group"), (Icon)ThemeProperties.ADD_ICON.get(), () -> {
                    this.playClickSound();
                    StringConfig c = new StringConfig(Pattern.compile("^.+$"));
                    EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                        this.chapterPanel.questScreen.openGui();
                        if (accepted) {
                            ChapterGroup group = new ChapterGroup(ClientQuestFile.INSTANCE);
                            group.title = (String)c.value;
                            new CreateObjectMessage(group, null).sendToServer();
                        }
                    });
                }));
                this.chapterPanel.questScreen.openContextMenu(contextMenu);
            }
        }

        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(40).draw(matrixStack, x + 1, y + 1, w - 2, h - 2);
            }
            ChatFormatting f = this.isMouseOver() ? ChatFormatting.WHITE : ChatFormatting.GRAY;
            this.icon.draw(matrixStack, x + 2, y + 3, 12, 12);
            theme.drawString(matrixStack, (Object)new TextComponent("").m_7220_(this.title).m_130940_(f), x + 16, y + 5);
            ((Color4I)ThemeProperties.WIDGET_BORDER.get(ClientQuestFile.INSTANCE)).draw(matrixStack, x, y + h - 1, w, 1);
            boolean canEdit = this.chapterPanel.questScreen.file.canEdit();
            ((Icon)(pinned ? ThemeProperties.PIN_ICON_ON : ThemeProperties.PIN_ICON_OFF).get()).draw(matrixStack, x + w - 16, y + 3, 12, 12);
            if (canEdit) {
                ((Icon)ThemeProperties.ADD_ICON.get()).draw(matrixStack, x + w - 31, y + 3, 12, 12);
            }
        }

        @Override
        public int getActualWidth(QuestScreen screen) {
            boolean canEdit = this.chapterPanel.questScreen.file.canEdit();
            return screen.getTheme().getStringWidth((FormattedText)this.title) + 36 + (canEdit ? 16 : 0);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            this.chapterPanel.questScreen.addInfoTooltip(list, this.chapterPanel.questScreen.file);
            if (this.getMouseX() > this.getX() + this.width - 18) {
                list.string(pinned ? "Stays open" : "Doesn't stay open");
            } else if (this.chapterPanel.questScreen.file.canEdit() && this.getMouseX() > this.getX() + this.width - 34) {
                list.translate("gui.add", new Object[0]);
            }
        }
    }

    public static class ChapterButton
    extends ListButton {
        public final Chapter chapter;
        public List<Component> description;

        public ChapterButton(ChapterPanel panel, Chapter c) {
            super(panel, c.getTitle(), c.getIcon());
            this.chapter = c;
            this.description = new ArrayList<Component>();
            for (String v : this.chapter.subtitle) {
                this.description.add((Component)new TextComponent("").m_7220_(ClientTextComponentUtils.parse((String)v)).m_130940_(ChatFormatting.GRAY));
            }
        }

        public void onClicked(MouseButton button) {
            if (this.chapterPanel.questScreen.file.canEdit() || !this.chapter.quests.isEmpty()) {
                this.playClickSound();
                if (this.chapterPanel.questScreen.selectedChapter != this.chapter) {
                    this.chapterPanel.questScreen.open(this.chapter, false);
                }
            }
            if (this.chapterPanel.questScreen.file.canEdit() && button.isRight()) {
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(), () -> new MoveChapterMessage(this.chapter.id, true).sendToServer()).setEnabled(() -> this.chapter.getIndex() > 0).setCloseMenu(false));
                contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("gui.move"), (Icon)ThemeProperties.MOVE_DOWN_ICON.get(), () -> new MoveChapterMessage(this.chapter.id, false).sendToServer()).setEnabled(() -> this.chapter.getIndex() < this.chapter.group.chapters.size() - 1).setCloseMenu(false));
                contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.gui.change_group"), Icons.COLOR_RGB, () -> new ChangeChapterGroupScreen(this.chapter).openGui()));
                contextMenu.add(ContextMenuItem.SEPARATOR);
                this.chapterPanel.questScreen.addObjectMenuItems(contextMenu, (Runnable)((Object)this.chapterPanel.questScreen), this.chapter);
                this.chapterPanel.questScreen.openContextMenu(contextMenu);
            }
        }

        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(40).draw(matrixStack, x + 1, y, w - 2, h);
            }
            Color4I c = this.chapter.getProgressColor(this.chapterPanel.questScreen.file.self, !this.isMouseOver());
            int o = this.chapter.group.isDefaultGroup() ? 0 : 7;
            this.icon.draw(matrixStack, x + 2 + o, y + 1, 12, 12);
            theme.drawString(matrixStack, (Object)new TextComponent("").m_7220_(this.title).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)c.rgb()))), x + 16 + o, y + 3);
            GuiHelper.setupDrawing();
            if (this.chapter.quests.isEmpty()) {
                ((Icon)ThemeProperties.CLOSE_ICON.get()).draw(matrixStack, x + w - 12, y + 3, 8, 8);
            } else if (this.chapterPanel.questScreen.file.self.hasUnclaimedRewards(Minecraft.m_91087_().f_91074_.m_142081_(), this.chapter)) {
                ((Icon)ThemeProperties.ALERT_ICON.get()).draw(matrixStack, x + w - 12, y + 3, 8, 8);
            }
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            this.chapterPanel.questScreen.addInfoTooltip(list, this.chapter);
            for (Component s : this.description) {
                list.add(s);
            }
        }

        @Override
        public int getActualWidth(QuestScreen screen) {
            int o;
            int n = o = this.chapter.group.isDefaultGroup() ? 0 : 7;
            if (this.chapter.quests.isEmpty() || this.chapterPanel.questScreen.file.self.hasUnclaimedRewards(Minecraft.m_91087_().f_91074_.m_142081_(), this.chapter)) {
                o += 16;
            }
            return screen.getTheme().getStringWidth((FormattedText)this.title) + 20 + o;
        }
    }

    public static class ChapterGroupButton
    extends ListButton {
        public final ChapterGroup group;
        public final List<Chapter> visibleChapters;

        public ChapterGroupButton(ChapterPanel panel, ChapterGroup g) {
            super(panel, g.getTitle(), g.getIcon());
            this.setSize(100, 18);
            this.group = g;
            this.visibleChapters = g.getVisibleChapters(panel.questScreen.file.self);
        }

        public void onClicked(MouseButton button) {
            if (this.chapterPanel.questScreen.file.canEdit() && this.getMouseX() > this.getX() + this.width - 15) {
                this.playClickSound();
                StringConfig c = new StringConfig(Pattern.compile("^.+$"));
                EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                    this.chapterPanel.questScreen.openGui();
                    if (accepted && !((String)c.value).isEmpty()) {
                        Chapter chapter = new Chapter(this.chapterPanel.questScreen.file, this.chapterPanel.questScreen.file.defaultChapterGroup);
                        chapter.title = (String)c.value;
                        CompoundTag extra = new CompoundTag();
                        extra.m_128356_("group", this.group.id);
                        new CreateObjectMessage(chapter, extra).sendToServer();
                    }
                    this.run();
                });
                return;
            }
            if (this.chapterPanel.questScreen.file.canEdit() && button.isRight() && !this.group.isDefaultGroup()) {
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(), () -> new MoveChapterGroupMessage(this.group.id, true).sendToServer()).setEnabled(() -> this.group.getIndex() > 1).setCloseMenu(false));
                contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("gui.move"), (Icon)ThemeProperties.MOVE_DOWN_ICON.get(), () -> new MoveChapterGroupMessage(this.group.id, false).sendToServer()).setEnabled(() -> this.group.getIndex() < this.group.file.chapterGroups.size() - 1).setCloseMenu(false));
                contextMenu.add(ContextMenuItem.SEPARATOR);
                this.chapterPanel.questScreen.addObjectMenuItems(contextMenu, (Runnable)((Object)this.chapterPanel.questScreen), this.group);
                this.chapterPanel.questScreen.openContextMenu(contextMenu);
                return;
            }
            this.group.guiCollapsed = !this.group.guiCollapsed;
            this.parent.refreshWidgets();
        }

        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(40).draw(matrixStack, x + 1, y, w - 2, h);
            }
            ChatFormatting f = this.isMouseOver() ? ChatFormatting.WHITE : ChatFormatting.GRAY;
            (this.group.guiCollapsed ? ARROW_COLLAPSED : ARROW_EXPANDED).withColor(Color4I.getChatFormattingColor((ChatFormatting)f)).draw(matrixStack, x + 3, y + 5, 8, 8);
            theme.drawString(matrixStack, (Object)new TextComponent("").m_7220_(this.title).m_130940_(f), x + 15, y + 5);
            boolean canEdit = this.chapterPanel.questScreen.file.canEdit();
            if (canEdit) {
                ((Icon)ThemeProperties.ADD_ICON.get()).draw(matrixStack, x + w - 14, y + 3, 12, 12);
            }
        }

        @Override
        public int getActualWidth(QuestScreen screen) {
            boolean canEdit = this.chapterPanel.questScreen.file.canEdit();
            return screen.getTheme().getStringWidth((FormattedText)this.title) + 20 + (canEdit ? 16 : 0);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            this.chapterPanel.questScreen.addInfoTooltip(list, this.group);
        }
    }

    public static abstract class ListButton
    extends Button {
        public final ChapterPanel chapterPanel;

        public ListButton(ChapterPanel panel, Component t, Icon i) {
            super((Panel)panel, t, i);
            this.setSize(100, 14);
            this.chapterPanel = panel;
        }

        public int getActualWidth(QuestScreen screen) {
            return screen.getTheme().getStringWidth((FormattedText)this.title) + 20;
        }

        public void addMouseOverText(TooltipList list) {
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.icon.getIngredient();
        }
    }
}

